/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.gui.modular.ModularGuiContainer;
import codechicken.lib.gui.modular.elements.GuiButton;
import codechicken.lib.gui.modular.elements.GuiContextMenu;
import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.elements.GuiEntityRenderer;
import codechicken.lib.gui.modular.elements.GuiItemStack;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.elements.GuiScrolling;
import codechicken.lib.gui.modular.elements.GuiSlider;
import codechicken.lib.gui.modular.elements.GuiText;
import codechicken.lib.gui.modular.elements.GuiTextField;
import codechicken.lib.gui.modular.elements.GuiTexture;
import codechicken.lib.gui.modular.lib.BackgroundRender;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.TextState;
import codechicken.lib.gui.modular.lib.geometry.Align;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.ConstrainedGeometry;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiListDialog;
import com.brandon3055.brandonscore.client.render.RenderUtils;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterAdults;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterEntity;
import com.brandon3055.brandonscore.lib.entityfilter.FilterGroup;
import com.brandon3055.brandonscore.lib.entityfilter.FilterHostile;
import com.brandon3055.brandonscore.lib.entityfilter.FilterItem;
import com.brandon3055.brandonscore.lib.entityfilter.FilterPlayer;
import com.brandon3055.brandonscore.lib.entityfilter.FilterTamed;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeLivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GuiEntityFilter
extends GuiElement<GuiEntityFilter> {
    private final EntityFilter entityFilter;
    private GuiScrolling scrollElement;
    private GuiSlider scrollBar;
    private GroupNode rootNode;
    private Function<BaseNode<?>, GuiElement<?>> nodeBgBuilder = GuiRectangle::invertedSlot;
    private Function<GuiButton, GuiText> textBtnBuilder = e -> new GuiText((GuiParent)e).setAlignment(Align.LEFT).setTextColour(() -> e.isMouseOver() ? 0xFFFFA0 : 0xE0E0E0);
    private Supplier<Integer> titleTextColour = () -> 0xFFFFFF;
    private Consumer<GuiSlider> scrollBarCustomizer = bar -> Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)bar).fill(-2130706433), (ConstrainedGeometry)bar.getSlider());

    public GuiEntityFilter(@NotNull GuiParent<?> parent, EntityFilter entityFilter) {
        super(parent);
        this.entityFilter = entityFilter;
        this.scrollElement = new GuiScrolling((GuiParent)this);
        Constraints.bind((ConstrainedGeometry)this.scrollElement, (ConstrainedGeometry)this);
        this.scrollElement.installContainerElement(new GuiElement((GuiParent)this.scrollElement));
        ((GuiElement)((GuiElement)this.scrollElement.getContentElement().constrain(GeoParam.WIDTH, null)).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.scrollElement.get(GeoParam.RIGHT)));
        this.initFilter();
    }

    public GuiEntityFilter initFilter() {
        GuiElement content = this.scrollElement.getContentElement();
        if (this.rootNode != null) {
            content.removeChild((GuiElement)this.rootNode);
        }
        this.rootNode = ((GroupNode)((GroupNode)((GroupNode)new GroupNode((GuiParent<?>)content, this.entityFilter, this).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)content.get(GeoParam.RIGHT)))).reloadGroup();
        if (this.scrollBar != null) {
            this.removeChild((GuiElement)this.scrollBar);
        }
        this.scrollBar = (GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)((GuiSlider)new GuiSlider((GuiParent)this, Axis.Y).setEnabled(() -> this.scrollElement.hiddenSize(Axis.Y) > 0.0)).setSliderState(this.scrollElement.scrollState(Axis.Y)).setScrollableElement((GuiElement)this).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.TOP)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)this.get(GeoParam.BOTTOM)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)5.0));
        this.scrollElement.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), () -> this.scrollElement.hiddenSize(Axis.Y) > 0.0 ? -this.scrollBar.xSize() - 1.0 : 0.0));
        this.scrollBarCustomizer.accept(this.scrollBar);
        return this;
    }

    public GuiEntityFilter setNodeBgBuilder(Function<BaseNode<?>, GuiElement<?>> nodeBgBuilder) {
        this.nodeBgBuilder = nodeBgBuilder;
        return this;
    }

    public GuiEntityFilter setScrollBarCustomizer(Consumer<GuiSlider> scrollBarCustomizer) {
        this.scrollBarCustomizer = scrollBarCustomizer;
        return this;
    }

    public GuiEntityFilter setTitleTextColour(Supplier<Integer> titleTextColour) {
        this.titleTextColour = titleTextColour;
        return this;
    }

    public GuiEntityFilter setTextBtnBuilder(Function<GuiButton, GuiText> textBtnBuilder) {
        this.textBtnBuilder = textBtnBuilder;
        return this;
    }

    private <T extends FilterBase> void layoutFilter(FilterNode<T> node, FilterType type) {
        switch (type) {
            case HOSTILE: {
                this.layoutHostile((FilterNode)((Object)SneakyUtils.unsafeCast(node)));
                break;
            }
            case TAMED: {
                this.layoutTamed((FilterNode)((Object)SneakyUtils.unsafeCast(node)));
                break;
            }
            case ADULTS: {
                this.layoutAdults((FilterNode)((Object)SneakyUtils.unsafeCast(node)));
                break;
            }
            case PLAYER: {
                this.layoutPlayer((FilterNode)((Object)SneakyUtils.unsafeCast(node)));
                break;
            }
            case ENTITY_TYPE: {
                this.layoutEntityType((FilterNode)((Object)SneakyUtils.unsafeCast(node)));
                break;
            }
            case ITEM_FILTER: {
                this.layoutItemFilter((FilterNode)((Object)SneakyUtils.unsafeCast(node)));
            }
        }
    }

    private GuiButton textButton(GuiElement<?> parent, Supplier<Component> label) {
        GuiButton button = new GuiButton(parent);
        button.setLabel(this.textBtnBuilder.apply(button).setTextSupplier(label));
        Constraints.bind((ConstrainedGeometry)button.getLabel(), (ConstrainedGeometry)button, (double)0.0, (double)2.0, (double)0.0, (double)2.0);
        button.constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> (double)this.font().m_92852_((FormattedText)label.get()) + 4.0));
        return button;
    }

    private void layoutHostile(FilterNode<FilterHostile> node) {
        node.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiButton toggleInclude = this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.hostile." + ((FilterHostile)node.getNode()).isWhitelistHostile())));
        Constraints.bind((ConstrainedGeometry)toggleInclude, node, (double)0.0, (double)0.0, (double)1.0, (double)12.0);
        toggleInclude.onPress(() -> ((FilterHostile)node.getNode()).setWhitelistHostile(!((FilterHostile)node.getNode()).isWhitelistHostile()));
    }

    private void layoutTamed(FilterNode<FilterTamed> node) {
        node.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)22.0));
        GuiButton toggleInclude = ((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.tamed." + ((FilterTamed)node.getNode()).isWhitelistTamed()))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)11.0))).onPress(() -> ((FilterTamed)node.getNode()).setWhitelistTamed(!((FilterTamed)node.getNode()).isWhitelistTamed()));
        Constraints.placeInside((ConstrainedGeometry)toggleInclude, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT);
        GuiButton toggleTamable = ((GuiButton)((GuiButton)this.textButton(node, () -> Component.m_237113_((String)"[ ").m_7220_((Component)Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.tamable." + ((FilterTamed)node.getNode()).isIncludeTamable()))).m_130946_(" ]")).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.tamable.info")})).onPress(() -> ((FilterTamed)node.getNode()).setIncludeTamable(!((FilterTamed)node.getNode()).isIncludeTamable()));
        Constraints.placeInside((ConstrainedGeometry)toggleTamable, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)6.0, (double)11.0);
    }

    private void layoutAdults(FilterNode<FilterAdults> node) {
        node.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)22.0));
        GuiButton toggleInclude = ((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.adults." + ((FilterAdults)node.getNode()).isWhitelistAdults()))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)11.0))).onPress(() -> ((FilterAdults)node.getNode()).setWhitelistAdults(!((FilterAdults)node.getNode()).isWhitelistAdults()));
        Constraints.placeInside((ConstrainedGeometry)toggleInclude, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT);
        GuiButton toggleAgeable = ((GuiButton)((GuiButton)this.textButton(node, () -> Component.m_237113_((String)"[ ").m_7220_((Component)Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.non_ageable." + ((FilterAdults)node.getNode()).isIncludeNonAgeable()))).m_130946_(" ]")).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.non_ageable.info")})).onPress(() -> ((FilterAdults)node.getNode()).setIncludeNonAgeable(!((FilterAdults)node.getNode()).isIncludeNonAgeable()));
        Constraints.placeInside((ConstrainedGeometry)toggleAgeable, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)6.0, (double)11.0);
    }

    private void layoutPlayer(FilterNode<FilterPlayer> node) {
        node.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)22.0));
        GuiButton toggleInclude = ((GuiButton)((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.player." + ((FilterPlayer)node.getNode()).isWhitelistPlayers()))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)11.0))).setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.player.info")})).onPress(() -> ((FilterPlayer)node.getNode()).setWhitelistPlayers(!((FilterPlayer)node.getNode()).isWhitelistPlayers()));
        Constraints.placeInside((ConstrainedGeometry)toggleInclude, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT);
        MutableComponent nameComponent = Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.player.name");
        GuiText nameLabel = ((GuiText)((GuiText)new GuiText(node, (Component)nameComponent).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.lambda$layoutPlayer$19((Component)nameComponent)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setShadow(false).setTextColour(this.titleTextColour);
        Constraints.placeInside((ConstrainedGeometry)nameLabel, node, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)2.0, (double)-2.0);
        GuiTextField nameField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField(node).setTextState(TextState.create(() -> ((FilterPlayer)node.getNode()).getPlayerName(), s -> ((FilterPlayer)node.getNode()).setPlayerName((String)s))).setFilter(s -> FilterPlayer.namePattern.matcher((CharSequence)s).find()).setMaxLength(16).setSuggestion((Component)Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.player.suggestion")).setSuggestionColour(0x202020).setSuggestionShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)nameLabel.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)nameLabel.get(GeoParam.RIGHT), (double)3.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)node.get(GeoParam.RIGHT), (double)-2.0));
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)nameField).fill(0x30FFFFFF), (ConstrainedGeometry)nameField, (double)0.0, (double)-1.0, (double)0.0, (double)0.0);
    }

    private void layoutEntityType(FilterNode<FilterEntity> node) {
        node.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)22.0));
        GuiButton toggleInclude = ((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.entity_type." + ((FilterEntity)node.getNode()).isWhitelistEntity()))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)11.0))).onPress(() -> ((FilterEntity)node.getNode()).setWhitelistEntity(!((FilterEntity)node.getNode()).isWhitelistEntity()));
        Constraints.placeInside((ConstrainedGeometry)toggleInclude, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT);
        MutableComponent nameComponent = Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.entity_type.name");
        GuiText nameLabel = ((GuiText)((GuiText)new GuiText(node, (Component)nameComponent).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> this.lambda$layoutEntityType$25((Component)nameComponent)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setShadow(false).setTextColour(this.titleTextColour);
        Constraints.placeInside((ConstrainedGeometry)nameLabel, node, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)2.0, (double)-2.0);
        GuiTextField nameField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField(node).setTextState(TextState.create(() -> ((FilterEntity)node.getNode()).getEntityName(), s -> ((FilterEntity)node.getNode()).setEntityName((String)s))).setFilter(ResourceLocation::m_135830_).setTextColor(() -> ForgeRegistries.ENTITY_TYPES.containsKey(ResourceLocation.m_135820_((String)((FilterEntity)node.getNode()).getEntityName())) ? 65280 : 0xFF0000).setTooltip(() -> {
            ResourceLocation name = ResourceLocation.m_135820_((String)((FilterEntity)node.getNode()).getEntityName());
            if (name == null || !ForgeRegistries.ENTITY_TYPES.containsKey(name)) {
                return Collections.singletonList(Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.entity_type.unknown").m_130940_(ChatFormatting.RED));
            }
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(name);
            return List.of(type.m_20676_().m_6881_(), Component.m_237113_((String)name.m_135827_()).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        })).setMaxLength(1024).setSuggestion((Component)Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.entity_type.suggestion")).setSuggestionColour(0x202020).setSuggestionShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)nameLabel.get(GeoParam.TOP), (double)0.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)nameLabel.get(GeoParam.RIGHT), (double)3.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)node.get(GeoParam.RIGHT), (double)-12.0));
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)nameField).fill(0x30FFFFFF), (ConstrainedGeometry)nameField, (double)0.0, (double)-1.0, (double)0.0, (double)0.0);
        GuiButton select = GuiButton.flatColourButton(node, () -> Component.m_237113_((String)"..."), h -> -16777216, h -> h != false ? -8355712 : -13619152);
        select.getLabel().setScroll(false);
        Constraints.bind((ConstrainedGeometry)select.getLabel(), (ConstrainedGeometry)select, (double)0.0, (double)1.0, (double)6.0, (double)0.0);
        Constraints.size((ConstrainedGeometry)select, (double)8.0, (double)8.0);
        Constraints.placeInside((ConstrainedGeometry)select, node, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)-2.0, (double)-2.0);
        select.setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.entity_type.find")});
        select.onPress(() -> {
            GuiListDialog dialog = GuiListDialog.create(node);
            Constraints.size(dialog, (double)160.0, (double)200.0);
            dialog.placeCenter();
            dialog.getList().setItemSpacing(1.0).setDisplayBuilder((entityTypeGuiList, entityType) -> {
                GuiRectangle bg = (GuiRectangle)new GuiRectangle((GuiParent)entityTypeGuiList).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)24.0));
                bg.fill(() -> bg.isMouseOver() ? -2144325584 : Integer.MIN_VALUE);
                GuiButton button = new GuiButton((GuiParent)bg).onPress(() -> {
                    ((FilterEntity)node.getNode()).setEntityName(String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(entityType)));
                    dialog.close();
                });
                Constraints.bind((ConstrainedGeometry)button, (ConstrainedGeometry)bg);
                GuiEntityRenderer render = (GuiEntityRenderer)((GuiEntityRenderer)new GuiEntityRenderer((GuiParent)bg).setEntity(ForgeRegistries.ENTITY_TYPES.getKey(entityType)).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)20.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)20.0));
                Constraints.placeInside((ConstrainedGeometry)render, (ConstrainedGeometry)bg, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)6.0, (double)0.0);
                ((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)bg, entityType.m_20676_()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.TOP), (double)2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.BOTTOM), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)render.get(GeoParam.RIGHT), (double)4.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.RIGHT), (double)-2.0))).setWrap(true);
                return bg;
            });
            dialog.setSearchStringFunc(entityType -> entityType.m_20676_().getString());
            if (this.entityFilter.isLivingOnly()) {
                dialog.addItems(ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(e -> {
                    try {
                        return e.m_20615_((Level)this.mc().f_91073_) instanceof IForgeLivingEntity;
                    }
                    catch (Throwable ex) {
                        return false;
                    }
                }).toList());
            } else {
                dialog.addItems(ForgeRegistries.ENTITY_TYPES.getValues());
            }
        });
    }

    private void layoutItemFilter(FilterNode<FilterItem> node) {
        node.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)42.0));
        GuiButton toggleInclude = ((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.item." + ((FilterItem)node.getNode()).isWhitelistMode()))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)11.0))).onPress(() -> ((FilterItem)node.getNode()).setWhitelistMode(!((FilterItem)node.getNode()).isWhitelistMode()));
        Constraints.placeInside((ConstrainedGeometry)toggleInclude, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT);
        GuiButton toggleTagMode = ((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.item.tag." + ((FilterItem)node.getNode()).isTagMode()))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).onPress(() -> ((FilterItem)node.getNode()).setTagMode(!((FilterItem)node.getNode()).isTagMode()));
        Constraints.placeInside((ConstrainedGeometry)toggleTagMode, node, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)0.0, (double)11.0);
        GuiRectangle slot = (GuiRectangle)((GuiRectangle)GuiRectangle.vanillaSlot(node).setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.set_stack")})).setEnabled(() -> !((FilterItem)node.getNode()).isTagMode());
        Constraints.size((ConstrainedGeometry)slot, (double)18.0, (double)18.0);
        Constraints.placeInside((ConstrainedGeometry)slot, node, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)2.0, (double)-2.0);
        GuiItemStack stack = new GuiItemStack((GuiParent)slot).setStack(() -> ((FilterItem)node.getNode()).getFilterStack());
        Constraints.bind((ConstrainedGeometry)stack, (ConstrainedGeometry)slot, (double)1.0);
        GuiButton setStack = new GuiButton((GuiParent)slot).onPress(() -> ((FilterItem)node.getNode()).setFilterStack(ItemStack.f_41583_), 1).onPress(() -> {
            Screen patt17745$temp = this.getModularGui().getScreen();
            if (patt17745$temp instanceof ModularGuiContainer) {
                ModularGuiContainer screen = (ModularGuiContainer)patt17745$temp;
                ((FilterItem)node.getNode()).setFilterStack(screen.m_6262_().m_142621_());
            }
        });
        Constraints.bind((ConstrainedGeometry)setStack, (ConstrainedGeometry)slot);
        slot.setJeiDropTarget(node.getNode()::setFilterStack, true);
        GuiButton matchMode = ((GuiButton)((GuiButton)((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.item.fuzzy." + ((FilterItem)node.getNode()).isFuzzyMatch()))).setEnabled(() -> slot.isEnabled() && !((FilterItem)node.getNode()).getFilterStack().m_41619_())).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.item.fuzzy.info")})).onPress(() -> ((FilterItem)node.getNode()).setFuzzyMatch(!((FilterItem)node.getNode()).isFuzzyMatch()));
        Constraints.placeOutside((ConstrainedGeometry)matchMode, (ConstrainedGeometry)slot, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)1.0, (double)9.0);
        GuiButton matchCount = ((GuiButton)((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.item.match_count." + ((FilterItem)node.getNode()).isMatchCount()))).setEnabled(() -> slot.isEnabled() && !((FilterItem)node.getNode()).getFilterStack().m_41619_())).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0))).onPress(() -> ((FilterItem)node.getNode()).setMatchCount(!((FilterItem)node.getNode()).isMatchCount()));
        Constraints.placeOutside((ConstrainedGeometry)matchCount, (ConstrainedGeometry)slot, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)1.0, (double)-9.0);
        GuiButton blockMode = ((GuiButton)((GuiButton)((GuiButton)this.textButton(node, () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.item." + (((FilterItem)node.getNode()).isFilterBlocks() ? "blocks_only" : (((FilterItem)node.getNode()).isFilterItems() ? "items_only" : "items_or_blocks"))))).setEnabled(() -> slot.isEnabled() && ((FilterItem)node.getNode()).getFilterStack().m_41619_())).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)11.0))).setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.item.items_blocks.info")})).onPress(() -> ((FilterItem)node.getNode()).cycleItemsBlocks());
        Constraints.placeOutside((ConstrainedGeometry)blockMode, (ConstrainedGeometry)slot, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)1.0, (double)0.0);
        GuiTextField tagField = (GuiTextField)((GuiTextField)((GuiTextField)((GuiTextField)new GuiTextField(node).setEnabled(() -> ((FilterItem)node.getNode()).isTagMode())).setTextState(TextState.create(() -> ((FilterItem)node.getNode()).getTagString(), s -> ((FilterItem)node.getNode()).setTagString((String)s))).setFilter(ResourceLocation::m_135830_).setTextColor(() -> ForgeRegistries.ITEMS.tags().getTagNames().anyMatch(e -> e.equals(((FilterItem)node.getNode()).getTag())) ? 65280 : 0xFF0000).setTooltipSingle(() -> {
            boolean match = ForgeRegistries.ITEMS.tags().getTagNames().anyMatch(e -> e.equals(((FilterItem)node.getNode()).getTag()));
            if (match) {
                int count = FastStream.of((Iterable)ForgeRegistries.ITEMS.getValues()).filter(e -> e.m_204114_().m_203656_(((FilterItem)node.getNode()).getTag())).count();
                return Component.m_237110_((String)"mod_gui.brandonscore.entity_filter.item.tag_matches", (Object[])new Object[]{count}).m_130940_(ChatFormatting.GREEN);
            }
            return Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.item.invalid_tag").m_130940_(ChatFormatting.RED);
        })).setMaxLength(1024).setSuggestion((Component)Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.item.tag.suggestion")).setSuggestionColour(0x202020).setSuggestionShadow(false).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)node.get(GeoParam.WIDTH), (double)-21.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        Constraints.placeInside((ConstrainedGeometry)tagField, node, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_LEFT, (double)4.0, (double)-2.0);
        Constraints.bind((ConstrainedGeometry)new GuiRectangle((GuiParent)tagField).fill(0x30FFFFFF), (ConstrainedGeometry)tagField, (double)0.0, (double)-2.0, (double)0.0, (double)-2.0);
        GuiButton select = GuiButton.flatColourButton(node, () -> Component.m_237113_((String)"..."), h -> -16777216, h -> h != false ? -8355712 : -13619152);
        select.getLabel().setScroll(false);
        Constraints.bind((ConstrainedGeometry)select.getLabel(), (ConstrainedGeometry)select, (double)0.0, (double)1.0, (double)6.0, (double)0.0);
        Constraints.size((ConstrainedGeometry)select, (double)12.0, (double)12.0);
        Constraints.placeInside((ConstrainedGeometry)select, node, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_RIGHT, (double)-2.0, (double)-2.0);
        select.setTooltip(new Component[]{Component.m_237115_((String)"mod_gui.brandonscore.entity_filter.item.find_tag")});
        select.onPress(() -> {
            GuiListDialog dialog = GuiListDialog.create(node);
            Constraints.size(dialog, (double)160.0, (double)200.0);
            dialog.placeCenter();
            dialog.getList().setItemSpacing(1.0).setDisplayBuilder((entityTypeGuiList, tag) -> {
                GuiRectangle bg = new GuiRectangle((GuiParent)entityTypeGuiList);
                bg.fill(() -> bg.isMouseOver() ? -2144325584 : Integer.MIN_VALUE);
                GuiText text = (GuiText)((GuiText)((GuiText)new GuiText((GuiParent)bg, (Component)Component.m_237113_((String)String.valueOf(tag.f_203868_()))).setWrap(true).autoHeight().constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)bg.get(GeoParam.RIGHT), (double)-2.0));
                bg.constrain(GeoParam.HEIGHT, (Constraint)Constraint.relative((GeoRef)text.get(GeoParam.HEIGHT), (double)2.0));
                GuiButton button = new GuiButton((GuiParent)bg).onPress(() -> {
                    ((FilterItem)node.getNode()).setTagString(String.valueOf(tag.f_203868_()));
                    dialog.close();
                });
                Constraints.bind((ConstrainedGeometry)button, (ConstrainedGeometry)bg);
                return bg;
            });
            dialog.setSearchStringFunc(tag -> String.valueOf(tag.f_203868_()));
            dialog.addItems(ForgeRegistries.ITEMS.tags().getTagNames().toList());
            dialog.getList().markDirty();
        });
    }

    private /* synthetic */ Double lambda$layoutEntityType$25(Component nameComponent) {
        return this.font().m_92852_((FormattedText)nameComponent);
    }

    private /* synthetic */ Double lambda$layoutPlayer$19(Component nameComponent) {
        return this.font().m_92852_((FormattedText)nameComponent);
    }

    public static class GroupNode
    extends BaseNode<GroupNode> {
        private final Int2ObjectMap<BaseNode<?>> nodes = new Int2ObjectOpenHashMap();
        private GuiText title;
        private int depth = 1;

        public GroupNode(@NotNull GuiParent<?> parent, FilterGroup group, GuiEntityFilter filterGui) {
            super(parent, group, filterGui);
            this.title = ((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.m_237115_((String)group.getTranslationKey())).setTextColour(filterGui.titleTextColour).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.WIDTH), (double)-4.0))).autoHeight();
            GuiButton add = new GuiButton((GuiParent)this);
            Constraints.size((ConstrainedGeometry)add, (double)10.0, (double)10.0);
            Constraints.placeInside((ConstrainedGeometry)add, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-12.0, (double)1.0);
            Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)add, BCGuiTextures.get("add")), (ConstrainedGeometry)add);
            add.onPress(() -> {
                GuiContextMenu menu = GuiContextMenu.tooltipStyleMenu((GuiParent)parent);
                for (FilterType type : FilterType.values()) {
                    if (!filterGui.entityFilter.isFilterAllowed(type) || type == FilterType.FILTER_GROUP && this.depth >= 4) continue;
                    MutableComponent name = Component.m_237115_((String)("mod_gui.brandonscore.entity_filter." + type.name().toLowerCase(Locale.ROOT)));
                    menu.addOption(() -> GroupNode.lambda$new$0((Component)name), () -> filterGui.entityFilter.clientAddNode(type, group));
                }
                menu.setNormalizedPos(this.getModularGui().computeMouseX(), this.getModularGui().computeMouseY());
            });
            Supplier<Component> label = () -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.and_group.button." + this.getNode().isAndGroup())).m_130940_(ChatFormatting.UNDERLINE);
            GuiButton mode = (GuiButton)((GuiButton)((GuiButton)filterGui.textButton(this, label).onPress(() -> this.getNode().setAndGroup(!this.getNode().isAndGroup())).setTooltipSingle(() -> Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.and_group." + this.getNode().isAndGroup())))).constrain(GeoParam.WIDTH, (Constraint)Constraint.dynamic(() -> (double)this.font().m_92852_((FormattedText)label.get()) + 4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)9.0));
            Constraints.placeOutside((ConstrainedGeometry)mode, (ConstrainedGeometry)add, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)0.0, (double)0.0);
        }

        public GroupNode reloadGroup() {
            this.nodes.forEach((integer, baseNode) -> this.removeChild((GuiElement)baseNode));
            this.nodes.clear();
            Object last = this.title;
            FilterGroup groupNode = this.getNode();
            if (this.filterGui.entityFilter.getNode(this.nodeID) == null) {
                return this;
            }
            for (int nodeID : groupNode.getSubNodeMap().keySet()) {
                BaseNode baseNode2;
                Object gn;
                FilterBase node = groupNode.getSubNodeMap().get(nodeID);
                if (node instanceof FilterGroup) {
                    gn = (FilterGroup)node;
                    baseNode2 = new GroupNode((GuiParent<?>)this, (FilterGroup)gn, this.filterGui);
                } else {
                    baseNode2 = new FilterNode<FilterBase>((GuiParent<?>)this, node, this.filterGui);
                }
                BaseNode newNode = baseNode2;
                newNode.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)3.0));
                newNode.constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0));
                newNode.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)last.get(GeoParam.BOTTOM), (double)(last instanceof GuiText ? 4.0 : 1.0)));
                newNode.parentGroup = this;
                last = newNode;
                if (newNode instanceof GroupNode) {
                    gn = (GroupNode)newNode;
                    ((GroupNode)((Object)gn)).depth = this.depth + 1;
                    ((GroupNode)((Object)gn)).reloadGroup();
                }
                this.nodes.put(nodeID, newNode);
            }
            if (this.nodes.isEmpty()) {
                this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
            } else {
                this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> this.nodes.values().stream().mapToDouble(ConstrainedGeometry::ySize).sum() + (double)(this.nodes.size() - 1) + this.title.ySize() + 4.0 + 4.0));
            }
            return this;
        }

        @Override
        public void tick(double mouseX, double mouseY) {
            super.tick(mouseX, mouseY);
            if (this.filterGui.entityFilter.getNode(this.nodeID) == null || !this.getNode().getSubNodeMap().keySet().stream().allMatch(key -> this.nodes.containsKey(key.intValue()))) {
                this.filterGui.rootNode.reloadGroup();
            }
        }

        @Override
        @NotNull
        public FilterGroup getNode() {
            return (FilterGroup)super.getNode();
        }

        private static /* synthetic */ Component lambda$new$0(Component name) {
            return name;
        }
    }

    public static class FilterNode<T extends FilterBase>
    extends BaseNode<FilterNode<T>> {
        public FilterNode(@NotNull GuiParent<?> parent, T filter, GuiEntityFilter filterGui) {
            super(parent, (FilterBase)filter, filterGui);
            filterGui.layoutFilter(this, ((FilterBase)filter).getType());
        }

        @NotNull
        public T getNode() {
            return (T)super.getNode();
        }
    }

    private static class PiCover
    extends GuiElement<PiCover>
    implements BackgroundRender {
        private final Supplier<Double> state;

        public PiCover(@NotNull GuiParent<?> parent, Supplier<Double> state) {
            super(parent);
            this.state = state;
        }

        public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            double state = this.state.get();
            if (state > 0.0) {
                RenderUtils.drawPieProgress(render, this.xMin(), this.yMin(), Math.min(this.xSize(), this.ySize()), state, 0.0, -65536, -16777216);
            }
        }
    }

    public static abstract class BaseNode<T extends GuiElement<T>>
    extends GuiElement<T> {
        protected final GuiElement<?> background;
        protected int trashState = 0;
        protected GroupNode parentGroup;
        protected double trashAnim = 0.0;
        protected long trashTime = 0L;
        protected int nodeID;
        protected FilterBase filterCache;
        protected final GuiEntityFilter filterGui;

        public BaseNode(@NotNull GuiParent<?> parent, FilterBase filter, GuiEntityFilter filterGui) {
            super(parent);
            this.nodeID = filter.getNodeId();
            this.filterCache = filter;
            this.filterGui = filterGui;
            boolean root = filter.getNodeId() == 0;
            this.background = filterGui.nodeBgBuilder.apply(this);
            Constraints.bind(this.background, (ConstrainedGeometry)this);
            GuiButton delete = new GuiButton((GuiParent)this);
            delete.setTooltip(new Component[]{Component.m_237115_((String)("mod_gui.brandonscore.entity_filter.delete." + (this.nodeID == 0 ? "all" : "node")))});
            Constraints.size((ConstrainedGeometry)delete, (double)10.0, (double)10.0);
            Constraints.placeInside((ConstrainedGeometry)delete, (ConstrainedGeometry)this, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-1.0, (double)1.0);
            Constraints.bind((ConstrainedGeometry)new GuiTexture((GuiParent)delete, BCGuiTextures.get(root ? "delete_all" : "delete")), (ConstrainedGeometry)delete);
            Constraints.bind((ConstrainedGeometry)new PiCover((GuiParent<?>)delete, () -> this.trashAnim), (ConstrainedGeometry)delete);
            delete.onPress(() -> {
                ++this.trashState;
                this.trashTime = System.currentTimeMillis() - 4800L;
                if (this.trashState == 3 && root) {
                    filterGui.entityFilter.clientClearFilter();
                } else if (this.trashState == 2 && !root) {
                    filterGui.entityFilter.clientRemoveNode(filter.getNodeId());
                } else {
                    this.trashTime = System.currentTimeMillis();
                }
            });
        }

        public void tick(double mouseX, double mouseY) {
            super.tick(mouseX, mouseY);
            double newAnim = (double)this.trashState / (this.nodeID == 0 ? 3.0 : 2.0);
            if (this.trashAnim > 0.9 && newAnim == 0.0) {
                this.trashAnim = 0.0;
            }
            this.trashAnim = MathHelper.approachExp((double)this.trashAnim, (double)newAnim, (double)0.5);
            if (this.trashState > 0 && System.currentTimeMillis() - this.trashTime > 5000L) {
                this.trashState = 0;
            }
            if (!(this.parentGroup == null || this.filterGui.entityFilter.getNode(this.nodeID) != null && this.parentGroup.getNode().getSubNodeMap().containsKey(this.nodeID))) {
                this.parentGroup.reloadGroup();
            }
        }

        @NotNull
        public FilterBase getNode() {
            FilterBase base = this.filterGui.entityFilter.getNode(this.nodeID);
            if (base == null) {
                return this.filterCache;
            }
            this.filterCache = base;
            return this.filterCache;
        }
    }
}

